<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:cif="cif" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.1">
  <xsl:param select="cif:xslShowHelp" name="xslShowHelp"/>
  <xsl:param select="cif:xslRootDirectory" name="xslRootDirectory"/>
  <xsl:template match="/">
    <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
    <html>
      <head>
        <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
        <!-- Title displayed in browser Title Bar -->
        <title lang="en">Výpis měření</title>
      </head>
      <body>
        <xsl:choose>
          <xsl:when test="$xslShowHelp = 'true'">
            <xsl:call-template name="StyleSheetHelp"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="InRoads">
              <center>
                <!-- Report Title -->
                <h2 lang="en">Výpis měření</h2>
                <p lang="en">
                  Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                  Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                </p>
              </center>
              <!-- Project Data -->
              <xsl:for-each select="SurveyFieldbook">
                <table class="margin" cellpadding="2" width="80%">
                  <tbody>
                    <tr>
                      <th align="right" lang="en">Projekt:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="@name"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en">Jednotky:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="@surveyLinearUnits"/>
                      </td>
                    </tr>
                  </tbody>
                </table>
                <hr />
                <!-- Survey Observation Data -->
                <xsl:for-each select="SurveyObsList">
                  <table class="margin" cellpadding="2" cellspacing="1" width="100%">
                    <colgroup span="2">
                      <col width="30%"/>
                      <col width="70%"/>
                    </colgroup>
                    <tbody>
                      <xsl:for-each select="SurveyObservation">
                        <tr>
                          <th align="right" lang="en">Název:&#xa0; </th>
                          <td>
                            <xsl:value-of select="@name"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Popis:&#xa0; </th>
                          <td>
                            <xsl:value-of select="@description"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Definice prvku:&#xa0; </th>
                          <td>
                            <xsl:value-of select="@code"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Kód propojení:&#xa0; </th>
                          <td>
                            <xsl:value-of select="@linkCode"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Zóna:&#xa0; </th>
                          <td>
                            <xsl:value-of select="@zone"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Vlastnost terénu:&#xa0; </th>
                          <td>
                            <xsl:value-of select="@terrainAttribute"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Dvojice vlastností:&#xa0; </th>
                          <td>
                            <xsl:value-of select="@attributesPair"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Řídící kódy:&#xa0; </th>
                          <td>
                            <xsl:value-of select="@controlCodes"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Orientace stroje:&#xa0; </th>
                          <td>
                            <xsl:value-of select="@instrumentOrientation"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Číslo sestavy:&#xa0; </th>
                          <td>
                            <xsl:value-of select="@setNumber"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Výška tyče:&#xa0; </th>
                          <td>
                            <xsl:value-of select="cif:distanceFormat(number(@rodHeight))"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Směrový úhel:&#xa0; </th>
                          <td>
                            <xsl:value-of select="cif:angularFormat(number(@horizontalAngle))"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Výškový úhel:&#xa0; </th>
                          <td>
                            <xsl:value-of select="cif:angularFormat(number(@verticalAngle))"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Šikmá vzdálenost:&#xa0; </th>
                          <td>
                            <xsl:value-of select="cif:distanceFormat(number(@slopeDistance))"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Název nastavení:&#xa0; </th>
                          <td>
                            <xsl:value-of select="@setupName"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Datový soubor:&#xa0; </th>
                          <td>
                            <xsl:value-of select="@dataFile"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">VBA makro:&#xa0; </th>
                          <td>
                            <xsl:value-of select="@vbaMacro"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Polní zápisník:&#xa0; </th>
                          <td>
                            <xsl:value-of select="@fieldBook"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Název stylu:&#xa0; </th>
                          <td>
                            <xsl:value-of select="@styleName"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Tyč Dálkoměrná lať:&#xa0; </th>
                          <td>
                            <xsl:value-of select="@rodStadia"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Horní dálkoměrná lať:&#xa0; </th>
                          <td>
                            <xsl:value-of select="@lowerStadia"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Spodní dálkoměrná lať:&#xa0; </th>
                          <td>
                            <xsl:value-of select="@upperStadia"/>
                          </td>
                        </tr>
                        <tr>
                          <th align="right" lang="en">Časová značka:&#xa0; </th>
                          <td>
                            <xsl:value-of select="@timeStamp"/>
                          </td>
                        </tr>
                        <tr>
                          <td colspan="2">&#xa0;</td>
                        </tr>
                      </xsl:for-each>
                    </tbody>
                  </table>
                </xsl:for-each>
              </xsl:for-each>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
      </body>
    </html>
  </xsl:template>
  <xsl:template name="StyleSheetHelp">
    <div class="section1">
      <h4 lang="en">Poznámky</h4>
      <p class="normal1" lang="en">
        Pro tento výpis potřebujete nejméně jeden polní zápisník v Průzkumníku projektu (Zaměření), který obsahuje minimálně jedno měření.
      </p>

      <p class="normal1">
        Pro nejlepší výsledek spusťte výpis z panelu Detaily.   Vyberte Všechna měření v Průzkumníku projektu, které jsou v panelu Detaily.  Zvýrazněte řádky, které chcete mít ve výpisu, a pravým tlačítkem zvolte Výpis na vybraných položkách.
      </p>
      <p class="normal1">
        Spuštění výpisu z obecného nástroje výpisu zaměření nebo kliknutí pravým tlačítkem na grafický prvek provede výpis pouze na jednom vybraném prvku.
      </p>
      <p class="normal1">Po otevření Průzkumníku výpisů zvolte správný formulář, který umí číst vygenerovaná data pro výpis.</p>
      <p class="small" lang="en">
        <em>&#xa9; 2012 Bentley Systems, Inc</em>
      </p>
    </div>
  </xsl:template>
</xsl:stylesheet>
